<?php defined('ALTUMCODE') || die() ?>

<div class="container">
    <?= \Altum\Alerts::output_alerts() ?>

    <?php if(settings()->main->breadcrumbs_is_enabled): ?>
        <nav aria-label="breadcrumb">
            <ol class="custom-breadcrumbs small">
                <li><a href="<?= url('tools') ?>"><?= l('tools.breadcrumb') ?></a> <i class="fas fa-fw fa-angle-right"></i></li>
                <li class="active" aria-current="page"><?= l('tools.signature_generator.name') ?></li>
            </ol>
        </nav>
    <?php endif ?>

    <div class="row mb-4">
        <div class="col-12 col-lg d-flex align-items-center mb-3 mb-lg-0 text-truncate">
            <h1 class="h4 m-0 text-truncate"><?= l('tools.signature_generator.name') ?></h1>

            <div class="ml-2">
                <span data-toggle="tooltip" title="<?= l('tools.signature_generator.description') ?>">
                    <i class="fas fa-fw fa-info-circle text-muted"></i>
                </span>
            </div>
        </div>

        <?= $this->views['ratings'] ?>
    </div>

    <div class="row">
        <div class="col-12">
            <div id="canvas_wrapper" class="card card-body p-0" style="background: #fff;">
                <canvas id="canvas" width="1106" height="500"></canvas>
            </div>
        </div>
    </div>

    <div class="mt-3">
        <input id="color" type="hidden" name="color" class="form-control" value="#000000" data-color-picker />
    </div>

    <div class="row mt-3">
        <div class="col-6 col-lg-3 mb-3">
            <button id="clear" type="button" class="btn btn-block btn-outline-secondary">
                <i class="fas fa-fw fa-sm fa-eraser"></i> <?= l('tools.signature_generator.clear') ?>
            </button>
        </div>

        <div class="col-6 col-lg-3 mb-3">
            <button id="undo" type="button" class="btn btn-block btn-outline-secondary">
                <i class="fas fa-fw fa-sm fa-undo"></i> <?= l('tools.signature_generator.undo') ?>
            </button>
        </div>

        <div class="col-12 col-lg-6 mb-3 dropdown">
            <button type="button" class="btn btn-block btn-primary dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-fw fa-sm fa-download mr-1"></i> <?= l('global.download') ?>
            </button>

            <div class="dropdown-menu">
                <button type="button" class="dropdown-item" onclick="download_as('image/svg+xml', 'download.svg');"><?= sprintf(l('global.download_as'), 'SVG') ?></button>
                <button type="button" class="dropdown-item" onclick="download_as(null, 'download.png');"><?= sprintf(l('global.download_as'), 'PNG') ?></button>
                <button type="button" class="dropdown-item" onclick="download_as('image/jpeg', 'download.jpg');"><?= sprintf(l('global.download_as'), 'JPG') ?></button>
                <button type="button" class="dropdown-item" onclick="download_as('image/webp', 'download.webp');"><?= sprintf(l('global.download_as'), 'WEBP') ?></button>
            </div>
        </div>
    </div>

    <?= $this->views['extra_content'] ?>

    <?= $this->views['similar_tools'] ?>

    <?= $this->views['popular_tools'] ?>
</div>

<?php ob_start() ?>
<script>
    'use strict';

    /*!
     * Signature Pad v5.1.2 | https://github.com/szimek/signature_pad
     * (c) 2025 Szymon Nowak | Released under the MIT license
     */
    (function(g,f){if(typeof exports=="object"&&typeof module<"u"){module.exports=f()}else if("function"==typeof define && define.amd){define("SignaturePad",f)}else {g["SignaturePad"]=f()}}(typeof globalThis < "u" ? globalThis : typeof self < "u" ? self : this,function(){var exports={};var __exports=exports;var module={exports};
        var y=Object.defineProperty;var D=Object.getOwnPropertyDescriptor;var U=Object.getOwnPropertyNames;var W=Object.prototype.hasOwnProperty;var b=(d,n)=>()=>(d&&(n=d(d=0)),n);var L=(d,n)=>{for(var t in n)y(d,t,{get:n[t],enumerable:!0})},G=(d,n,t,e)=>{if(n&&typeof n=="object"||typeof n=="function")for(let i of U(n))!W.call(d,i)&&i!==t&&y(d,i,{get:()=>n[i],enumerable:!(e=D(n,i))||e.enumerable});return d};var B=d=>G(y({},"__esModule",{value:!0}),d);var f,P=b(()=>{"use strict";f=class{x;y;pressure;time;constructor(n,t,e,i){if(isNaN(n)||isNaN(t))throw new Error(`Point is invalid: (${n}, ${t})`);this.x=+n,this.y=+t,this.pressure=e||0,this.time=i||Date.now()}distanceTo(n){return Math.sqrt(Math.pow(this.x-n.x,2)+Math.pow(this.y-n.y,2))}equals(n){return this.x===n.x&&this.y===n.y&&this.pressure===n.pressure&&this.time===n.time}velocityFrom(n){return this.time!==n.time?this.distanceTo(n)/(this.time-n.time):0}}});var x,S=b(()=>{"use strict";P();x=class d{constructor(n,t,e,i,o,r){this.startPoint=n;this.control2=t;this.control1=e;this.endPoint=i;this.startWidth=o;this.endWidth=r}static fromPoints(n,t){let e=this.calculateControlPoints(n[0],n[1],n[2]).c2,i=this.calculateControlPoints(n[1],n[2],n[3]).c1;return new d(n[1],e,i,n[2],t.start,t.end)}static calculateControlPoints(n,t,e){let i=n.x-t.x,o=n.y-t.y,r=t.x-e.x,c=t.y-e.y,a={x:(n.x+t.x)/2,y:(n.y+t.y)/2},h={x:(t.x+e.x)/2,y:(t.y+e.y)/2},l=Math.sqrt(i*i+o*o),s=Math.sqrt(r*r+c*c),v=a.x-h.x,p=a.y-h.y,m=l+s==0?0:s/(l+s),_={x:h.x+v*m,y:h.y+p*m},u=t.x-_.x,g=t.y-_.y;return{c1:new f(a.x+u,a.y+g),c2:new f(h.x+u,h.y+g)}}length(){let t=0,e,i;for(let o=0;o<=10;o+=1){let r=o/10,c=this.point(r,this.startPoint.x,this.control1.x,this.control2.x,this.endPoint.x),a=this.point(r,this.startPoint.y,this.control1.y,this.control2.y,this.endPoint.y);if(o>0){let h=c-e,l=a-i;t+=Math.sqrt(h*h+l*l)}e=c,i=a}return t}point(n,t,e,i,o){return t*(1-n)*(1-n)*(1-n)+3*e*(1-n)*(1-n)*n+3*i*(1-n)*n*n+o*n*n*n}}});var E,C=b(()=>{"use strict";E=class{_et;constructor(){try{this._et=new EventTarget}catch{this._et=document}}addEventListener(n,t,e){this._et.addEventListener(n,t,e)}dispatchEvent(n){return this._et.dispatchEvent(n)}removeEventListener(n,t,e){this._et.removeEventListener(n,t,e)}}});function O(d,n=250){let t=0,e=null,i,o,r,c=()=>{t=Date.now(),e=null,i=d.apply(o,r),e||(o=null,r=[])};return function(...h){let l=Date.now(),s=n-(l-t);return o=this,r=h,s<=0||s>n?(e&&(clearTimeout(e),e=null),t=l,i=d.apply(o,r),e||(o=null,r=[])):e||(e=window.setTimeout(c,s)),i}}var T=b(()=>{"use strict"});var k={};L(k,{default:()=>w});var w,M=b(()=>{"use strict";S();P();C();T();P();w=class d extends E{constructor(t,e={}){super();this.canvas=t;this.velocityFilterWeight=e.velocityFilterWeight||.7,this.minWidth=e.minWidth||.5,this.maxWidth=e.maxWidth||2.5,this.throttle=e.throttle??16,this.minDistance=e.minDistance??5,this.dotSize=e.dotSize||0,this.penColor=e.penColor||"black",this.backgroundColor=e.backgroundColor||"rgba(0,0,0,0)",this.compositeOperation=e.compositeOperation||"source-over",this.canvasContextOptions=e.canvasContextOptions??{},this._strokeMoveUpdate=this.throttle?O(d.prototype._strokeUpdate,this.throttle):d.prototype._strokeUpdate,this._handleMouseDown=this._handleMouseDown.bind(this),this._handleMouseMove=this._handleMouseMove.bind(this),this._handleMouseUp=this._handleMouseUp.bind(this),this._handleTouchStart=this._handleTouchStart.bind(this),this._handleTouchMove=this._handleTouchMove.bind(this),this._handleTouchEnd=this._handleTouchEnd.bind(this),this._handlePointerDown=this._handlePointerDown.bind(this),this._handlePointerMove=this._handlePointerMove.bind(this),this._handlePointerUp=this._handlePointerUp.bind(this),this._handlePointerCancel=this._handlePointerCancel.bind(this),this._handleTouchCancel=this._handleTouchCancel.bind(this),this._ctx=t.getContext("2d",this.canvasContextOptions),this.clear(),this.on()}dotSize;minWidth;maxWidth;penColor;minDistance;velocityFilterWeight;compositeOperation;backgroundColor;throttle;canvasContextOptions;_ctx;_drawingStroke=!1;_isEmpty=!0;_dataUrl;_dataUrlOptions;_lastPoints=[];_data=[];_lastVelocity=0;_lastWidth=0;_strokeMoveUpdate;_strokePointerId;clear(){let{_ctx:t,canvas:e}=this;t.fillStyle=this.backgroundColor,t.clearRect(0,0,e.width,e.height),t.fillRect(0,0,e.width,e.height),this._data=[],this._reset(this._getPointGroupOptions()),this._isEmpty=!0,this._dataUrl=void 0,this._dataUrlOptions=void 0,this._strokePointerId=void 0}redraw(){let t=this._data,e=this._dataUrl,i=this._dataUrlOptions;this.clear(),e&&this.fromDataURL(e,i),this.fromData(t,{clear:!1})}fromDataURL(t,e={}){return new Promise((i,o)=>{let r=new Image,c=e.ratio||window.devicePixelRatio||1,a=e.width||this.canvas.width/c,h=e.height||this.canvas.height/c,l=e.xOffset||0,s=e.yOffset||0;this._reset(this._getPointGroupOptions()),r.onload=()=>{this._ctx.drawImage(r,l,s,a,h),i()},r.onerror=v=>{o(v)},r.crossOrigin="anonymous",r.src=t,this._isEmpty=!1,this._dataUrl=t,this._dataUrlOptions={...e}})}toDataURL(t="image/png",e){switch(t){case"image/svg+xml":return typeof e!="object"&&(e=void 0),`data:image/svg+xml;base64,${btoa(this.toSVG(e))}`;default:return typeof e!="number"&&(e=void 0),this.canvas.toDataURL(t,e)}}on(){this.canvas.style.touchAction="none",this.canvas.style.msTouchAction="none",this.canvas.style.userSelect="none";let t=/Macintosh/.test(navigator.userAgent)&&"ontouchstart"in document;window.PointerEvent&&!t?this._handlePointerEvents():(this._handleMouseEvents(),"ontouchstart"in window&&this._handleTouchEvents())}off(){this.canvas.style.touchAction="auto",this.canvas.style.msTouchAction="auto",this.canvas.style.userSelect="auto",this.canvas.removeEventListener("pointerdown",this._handlePointerDown),this.canvas.removeEventListener("mousedown",this._handleMouseDown),this.canvas.removeEventListener("touchstart",this._handleTouchStart),this._removeMoveUpEventListeners()}_getListenerFunctions(){let t=window.document===this.canvas.ownerDocument?window:this.canvas.ownerDocument.defaultView??this.canvas.ownerDocument;return{addEventListener:t.addEventListener.bind(t),removeEventListener:t.removeEventListener.bind(t)}}_removeMoveUpEventListeners(){let{removeEventListener:t}=this._getListenerFunctions();t("pointermove",this._handlePointerMove),t("pointerup",this._handlePointerUp),t("pointercancel",this._handlePointerCancel),t("mousemove",this._handleMouseMove),t("mouseup",this._handleMouseUp),t("touchmove",this._handleTouchMove),t("touchend",this._handleTouchEnd),t("touchcancel",this._handleTouchCancel)}isEmpty(){return this._isEmpty}fromData(t,{clear:e=!0}={}){e&&this.clear(),this._fromData(t,this._drawCurve.bind(this),this._drawDot.bind(this)),this._data=this._data.concat(t)}toData(){return this._data}_isLeftButtonPressed(t,e){return e?t.buttons===1:(t.buttons&1)===1}_pointerEventToSignatureEvent(t){return{event:t,type:t.type,x:t.clientX,y:t.clientY,pressure:"pressure"in t?t.pressure:0}}_touchEventToSignatureEvent(t){let e=t.changedTouches[0];return{event:t,type:t.type,x:e.clientX,y:e.clientY,pressure:e.force}}_handleMouseDown(t){!this._isLeftButtonPressed(t,!0)||this._drawingStroke||this._strokeBegin(this._pointerEventToSignatureEvent(t))}_handleMouseMove(t){if(!this._isLeftButtonPressed(t,!0)||!this._drawingStroke){this._strokeEnd(this._pointerEventToSignatureEvent(t),!1);return}this._strokeMoveUpdate(this._pointerEventToSignatureEvent(t))}_handleMouseUp(t){this._isLeftButtonPressed(t)||this._strokeEnd(this._pointerEventToSignatureEvent(t))}_handleTouchStart(t){t.targetTouches.length!==1||this._drawingStroke||(t.cancelable&&t.preventDefault(),this._strokeBegin(this._touchEventToSignatureEvent(t)))}_handleTouchMove(t){if(t.targetTouches.length===1){if(t.cancelable&&t.preventDefault(),!this._drawingStroke){this._strokeEnd(this._touchEventToSignatureEvent(t),!1);return}this._strokeMoveUpdate(this._touchEventToSignatureEvent(t))}}_handleTouchEnd(t){t.targetTouches.length===0&&(t.cancelable&&t.preventDefault(),this._strokeEnd(this._touchEventToSignatureEvent(t)))}_handlePointerCancel(t){this._allowPointerId(t)&&(t.preventDefault(),this._strokeEnd(this._pointerEventToSignatureEvent(t),!1))}_handleTouchCancel(t){t.cancelable&&t.preventDefault(),this._strokeEnd(this._touchEventToSignatureEvent(t),!1)}_getPointerId(t){return t.persistentDeviceId||t.pointerId}_allowPointerId(t,e=!1){return typeof this._strokePointerId>"u"?e:this._getPointerId(t)===this._strokePointerId}_handlePointerDown(t){this._drawingStroke||!this._isLeftButtonPressed(t)||!this._allowPointerId(t,!0)||(this._strokePointerId=this._getPointerId(t),t.preventDefault(),this._strokeBegin(this._pointerEventToSignatureEvent(t)))}_handlePointerMove(t){if(this._allowPointerId(t)){if(!this._isLeftButtonPressed(t,!0)||!this._drawingStroke){this._strokeEnd(this._pointerEventToSignatureEvent(t),!1);return}t.preventDefault(),this._strokeMoveUpdate(this._pointerEventToSignatureEvent(t))}}_handlePointerUp(t){this._isLeftButtonPressed(t)||!this._allowPointerId(t)||(t.preventDefault(),this._strokeEnd(this._pointerEventToSignatureEvent(t)))}_getPointGroupOptions(t){return{penColor:t&&"penColor"in t?t.penColor:this.penColor,dotSize:t&&"dotSize"in t?t.dotSize:this.dotSize,minWidth:t&&"minWidth"in t?t.minWidth:this.minWidth,maxWidth:t&&"maxWidth"in t?t.maxWidth:this.maxWidth,velocityFilterWeight:t&&"velocityFilterWeight"in t?t.velocityFilterWeight:this.velocityFilterWeight,compositeOperation:t&&"compositeOperation"in t?t.compositeOperation:this.compositeOperation}}_strokeBegin(t){if(!this.dispatchEvent(new CustomEvent("beginStroke",{detail:t,cancelable:!0})))return;let{addEventListener:i}=this._getListenerFunctions();switch(t.event.type){case"mousedown":i("mousemove",this._handleMouseMove,{passive:!1}),i("mouseup",this._handleMouseUp,{passive:!1});break;case"touchstart":i("touchmove",this._handleTouchMove,{passive:!1}),i("touchend",this._handleTouchEnd,{passive:!1}),i("touchcancel",this._handleTouchCancel,{passive:!1});break;case"pointerdown":i("pointermove",this._handlePointerMove,{passive:!1}),i("pointerup",this._handlePointerUp,{passive:!1}),i("pointercancel",this._handlePointerCancel,{passive:!1});break;default:}this._drawingStroke=!0;let o=this._getPointGroupOptions(),r={...o,points:[]};this._data.push(r),this._reset(o),this._strokeUpdate(t)}_strokeUpdate(t){if(!this._drawingStroke)return;if(this._data.length===0){this._strokeBegin(t);return}this.dispatchEvent(new CustomEvent("beforeUpdateStroke",{detail:t}));let e=this._createPoint(t.x,t.y,t.pressure),i=this._data[this._data.length-1],o=i.points,r=o.length>0&&o[o.length-1],c=r?e.distanceTo(r)<=this.minDistance:!1,a=this._getPointGroupOptions(i);if(!r||!(r&&c)){let h=this._addPoint(e,a);r?h&&this._drawCurve(h,a):this._drawDot(e,a),o.push({time:e.time,x:e.x,y:e.y,pressure:e.pressure})}this.dispatchEvent(new CustomEvent("afterUpdateStroke",{detail:t}))}_strokeEnd(t,e=!0){this._removeMoveUpEventListeners(),this._drawingStroke&&(e&&this._strokeUpdate(t),this._drawingStroke=!1,this._strokePointerId=void 0,this.dispatchEvent(new CustomEvent("endStroke",{detail:t})))}_handlePointerEvents(){this._drawingStroke=!1,this.canvas.addEventListener("pointerdown",this._handlePointerDown,{passive:!1})}_handleMouseEvents(){this._drawingStroke=!1,this.canvas.addEventListener("mousedown",this._handleMouseDown,{passive:!1})}_handleTouchEvents(){this.canvas.addEventListener("touchstart",this._handleTouchStart,{passive:!1})}_reset(t){this._lastPoints=[],this._lastVelocity=0,this._lastWidth=(t.minWidth+t.maxWidth)/2,this._ctx.fillStyle=t.penColor,this._ctx.globalCompositeOperation=t.compositeOperation}_createPoint(t,e,i){let o=this.canvas.getBoundingClientRect();return new f(t-o.left,e-o.top,i,new Date().getTime())}_addPoint(t,e){let{_lastPoints:i}=this;if(i.push(t),i.length>2){i.length===3&&i.unshift(i[0]);let o=this._calculateCurveWidths(i[1],i[2],e),r=x.fromPoints(i,o);return i.shift(),r}return null}_calculateCurveWidths(t,e,i){let o=i.velocityFilterWeight*e.velocityFrom(t)+(1-i.velocityFilterWeight)*this._lastVelocity,r=this._strokeWidth(o,i),c={end:r,start:this._lastWidth};return this._lastVelocity=o,this._lastWidth=r,c}_strokeWidth(t,e){return Math.max(e.maxWidth/(t+1),e.minWidth)}_drawCurveSegment(t,e,i){let o=this._ctx;o.moveTo(t,e),o.arc(t,e,i,0,2*Math.PI,!1),this._isEmpty=!1}_drawCurve(t,e){let i=this._ctx,o=t.endWidth-t.startWidth,r=Math.ceil(t.length())*2;i.beginPath(),i.fillStyle=e.penColor;for(let c=0;c<r;c+=1){let a=c/r,h=a*a,l=h*a,s=1-a,v=s*s,p=v*s,m=p*t.startPoint.x;m+=3*v*a*t.control1.x,m+=3*s*h*t.control2.x,m+=l*t.endPoint.x;let _=p*t.startPoint.y;_+=3*v*a*t.control1.y,_+=3*s*h*t.control2.y,_+=l*t.endPoint.y;let u=Math.min(t.startWidth+l*o,e.maxWidth);this._drawCurveSegment(m,_,u)}i.closePath(),i.fill()}_drawDot(t,e){let i=this._ctx,o=e.dotSize>0?e.dotSize:(e.minWidth+e.maxWidth)/2;i.beginPath(),this._drawCurveSegment(t.x,t.y,o),i.closePath(),i.fillStyle=e.penColor,i.fill()}_fromData(t,e,i){for(let o of t){let{points:r}=o,c=this._getPointGroupOptions(o);if(r.length>1)for(let a=0;a<r.length;a+=1){let h=r[a],l=new f(h.x,h.y,h.pressure,h.time);a===0&&this._reset(c);let s=this._addPoint(l,c);s&&e(s,c)}else this._reset(c),i(r[0],c)}}toSVG({includeBackgroundColor:t=!1,includeDataUrl:e=!1}={}){let i=this._data,o=Math.max(window.devicePixelRatio||1,1),r=0,c=0,a=this.canvas.width/o,h=this.canvas.height/o,l=document.createElementNS("http://www.w3.org/2000/svg","svg");if(l.setAttribute("xmlns","http://www.w3.org/2000/svg"),l.setAttribute("xmlns:xlink","http://www.w3.org/1999/xlink"),l.setAttribute("viewBox",`${r} ${c} ${a} ${h}`),l.setAttribute("width",a.toString()),l.setAttribute("height",h.toString()),t&&this.backgroundColor){let s=document.createElement("rect");s.setAttribute("width","100%"),s.setAttribute("height","100%"),s.setAttribute("fill",this.backgroundColor),l.appendChild(s)}if(e&&this._dataUrl){let s=this._dataUrlOptions?.ratio||window.devicePixelRatio||1,v=this._dataUrlOptions?.width||this.canvas.width/s,p=this._dataUrlOptions?.height||this.canvas.height/s,m=this._dataUrlOptions?.xOffset||0,_=this._dataUrlOptions?.yOffset||0,u=document.createElement("image");u.setAttribute("x",m.toString()),u.setAttribute("y",_.toString()),u.setAttribute("width",v.toString()),u.setAttribute("height",p.toString()),u.setAttribute("preserveAspectRatio","none"),u.setAttribute("href",this._dataUrl),l.appendChild(u)}return this._fromData(i,(s,{penColor:v})=>{let p=document.createElement("path");if(!isNaN(s.control1.x)&&!isNaN(s.control1.y)&&!isNaN(s.control2.x)&&!isNaN(s.control2.y)){let m=`M ${s.startPoint.x.toFixed(3)},${s.startPoint.y.toFixed(3)} C ${s.control1.x.toFixed(3)},${s.control1.y.toFixed(3)} ${s.control2.x.toFixed(3)},${s.control2.y.toFixed(3)} ${s.endPoint.x.toFixed(3)},${s.endPoint.y.toFixed(3)}`;p.setAttribute("d",m),p.setAttribute("stroke-width",(s.endWidth*2.25).toFixed(3)),p.setAttribute("stroke",v),p.setAttribute("fill","none"),p.setAttribute("stroke-linecap","round"),l.appendChild(p)}},(s,{penColor:v,dotSize:p,minWidth:m,maxWidth:_})=>{let u=document.createElement("circle"),g=p>0?p:(m+_)/2;u.setAttribute("r",g.toString()),u.setAttribute("cx",s.x.toString()),u.setAttribute("cy",s.y.toString()),u.setAttribute("fill",v),l.appendChild(u)}),l.outerHTML}}});module.exports=(M(),B(k)).default;

        if(__exports != exports)module.exports = exports;return module.exports}));
</script>

<script>
    'use strict';

/* Initiate signature pad on canvas */
    const canvas = document.querySelector('canvas');
    const signature_pad = new SignaturePad(canvas);

    /* Responsive helper */
    let resize_canvas = () => {

        let canvas = document.querySelector('canvas');
        let device_pixel_ratio = Math.max(window.devicePixelRatio || 1, 1);

        let wrapper = document.querySelector('#canvas_wrapper');

        canvas.width  = wrapper.offsetWidth * device_pixel_ratio;
        canvas.height = wrapper.offsetHeight * device_pixel_ratio;

        canvas.style.width  = wrapper.offsetWidth + 'px';
        canvas.style.height = wrapper.offsetHeight + 'px';

        let context = canvas.getContext('2d');
        context.scale(device_pixel_ratio, device_pixel_ratio);

        signature_pad.clear();

    }

    let timer = null;

    let timer_function = () => {
        clearTimeout(timer);

        timer = setTimeout(() => {
            resize_canvas();
            signature_pad.clear();
        }, 500);
    }

    window.addEventListener('resize', timer_function);
    timer_function();

    /* Custom writing color */
    document.querySelector('#color').addEventListener('change', event => {
        let hex_code = event.currentTarget.value.split('');
        let r = parseInt(hex_code[1]+hex_code[2],16);
        let g = parseInt(hex_code[3]+hex_code[4],16);
        let b = parseInt(hex_code[5]+hex_code[6],16);
        signature_pad.penColor = `rgb(${r}, ${g}, ${b})`;
    });

    /* Button handlers */
    document.querySelector('#clear').addEventListener('click', event => {
        signature_pad.clear();
    });

    document.querySelector('#undo').addEventListener('click', event => {
        let data = signature_pad.toData();
        if(data) {
            data.pop();
            signature_pad.fromData(data);
        }
    })

    /* Download function */
    let download_as = (type = null, name) => {
        let link = document.createElement('a');
        link.download = name;
        link.style.opacity = '0';
        document.body.appendChild(link);
        link.href = signature_pad.toDataURL(type);
        link.click();
        link.remove();
    }
</script>
<?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>

<?php include_view(THEME_PATH . 'views/partials/clipboard_js.php') ?>
<?php include_view(THEME_PATH . 'views/partials/color_picker_js.php') ?>
